/*
 * Decompiled with CFR 0.152.
 */
package jgamebase.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import jgamebase.Const;
import jgamebase.db.Db;
import jgamebase.db.model.Game;
import jgamebase.gui.Gui;
import jgamebase.model.Databases;
import jgamebase.tools.FileTools;

public class AboutDialog
extends JDialog {
    private static final long serialVersionUID = -3466345422382821256L;
    private JLabel aboutGameMostPlayed;
    private JLabel aboutGamesPlayed;
    private JLabel aboutIcon;
    private JLabel aboutMusicPlayed;
    private JLabel aboutName;
    private JLabel aboutSince;
    private JTextArea credits;
    private JTextArea gamebaseAbout;
    private JLabel gamebaseIcon;
    private JLabel gamebaseName;
    private JTextArea license;
    private JTextArea versionHistory;

    public AboutDialog(Frame parent, boolean modal) {
        super(parent, modal);
        Game gameMostPlayed;
        this.initComponents();
        this.aboutIcon.setIcon(Const.ICON_JGAMEBASE);
        this.aboutName.setText(Databases.getCurrent().getDisplayName());
        this.aboutSince.setText(Databases.getCurrent().getPreferences().get("about_since"));
        this.aboutGamesPlayed.setText(Databases.getCurrent().getPreferences().get("about_games_played"));
        this.aboutMusicPlayed.setText(Databases.getCurrent().getPreferences().get("about_music_played"));
        this.aboutGameMostPlayed.setText("");
        int maxTimesPlayed = Db.getMaxTimesPlayed();
        if (maxTimesPlayed > 0 && (gameMostPlayed = Db.getOneGameByTimesPlayed(maxTimesPlayed)) != null) {
            this.aboutGameMostPlayed.setText(String.valueOf(gameMostPlayed.getName()) + " (" + maxTimesPlayed + " times)");
        }
        String history = "";
        try {
            history = FileTools.readFileAsString("History.txt");
        }
        catch (IOException iOException) {}
        if (history != null && !history.isEmpty()) {
            this.versionHistory.setText(history);
        } else {
            this.versionHistory.setText("Sorry no history file 'History.txt' found.");
        }
        this.versionHistory.setCaretPosition(0);
        String iconFilename = new File(Databases.getCurrent().getPath(), "Gfx/AboutScreen_120x200.gif").toString();
        if (new File(iconFilename).exists()) {
            this.gamebaseIcon.setIcon(new ImageIcon(iconFilename));
        } else {
            Const.log.warn((Object)("No icon '" + iconFilename + "' for database " + Databases.getCurrent().getName() + " found."));
        }
        this.gamebaseName.setText(Databases.getCurrent().getDisplayName());
        String dbCredits = "";
        try {
            dbCredits = FileTools.readFileAsString(new File(Databases.getCurrent().getPath(), "Credits.txt").toString());
        }
        catch (IOException iOException) {}
        if (dbCredits != null && !dbCredits.isEmpty()) {
            this.gamebaseAbout.setText(dbCredits);
        } else {
            this.gamebaseAbout.setText("Sorry no credits file 'Credits.txt' in database directory found.");
        }
        this.gamebaseAbout.setCaretPosition(0);
        this.credits.setCaretPosition(0);
        this.license.setCaretPosition(0);
        this.setMinimumSize(this.getSize());
        this.setVisible(true);
    }

    private void initComponents() {
        JTabbedPane jTabbedPane1 = new JTabbedPane();
        Gui.fixLookAndFeel(jTabbedPane1);
        JPanel jPanel1 = new JPanel();
        JPanel jPanel6 = new JPanel();
        this.aboutIcon = new JLabel();
        JLabel jLabel2 = new JLabel();
        JLabel jLabel3 = new JLabel();
        JLabel jLabel4 = new JLabel();
        JPanel jPanel7 = new JPanel();
        JLabel jLabel5 = new JLabel();
        this.aboutName = new JLabel();
        JLabel jLabel7 = new JLabel();
        this.aboutSince = new JLabel();
        JLabel jLabel9 = new JLabel();
        this.aboutGamesPlayed = new JLabel();
        JLabel jLabel11 = new JLabel();
        this.aboutMusicPlayed = new JLabel();
        JLabel jLabel13 = new JLabel();
        this.aboutGameMostPlayed = new JLabel();
        JPanel jPanel8 = new JPanel();
        JLabel gbCopyright = new JLabel();
        JLabel jgbCopyright = new JLabel();
        JPanel jPanel2 = new JPanel();
        JScrollPane jScrollPane1 = new JScrollPane();
        this.versionHistory = new JTextArea();
        JPanel jPanel3 = new JPanel();
        this.gamebaseName = new JLabel();
        this.gamebaseIcon = new JLabel();
        JScrollPane jScrollPane2 = new JScrollPane();
        this.gamebaseAbout = new JTextArea();
        JPanel jPanel4 = new JPanel();
        JScrollPane jScrollPane3 = new JScrollPane();
        this.credits = new JTextArea();
        JPanel jPanel5 = new JPanel();
        this.license = new JTextArea();
        this.setTitle("About jGameBase...");
        this.setModal(true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                AboutDialog.this.formWindowClosing(evt);
            }
        });
        jTabbedPane1.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        jPanel1.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        jPanel1.setLayout(new BorderLayout());
        jPanel6.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 3, 0);
        jPanel6.add((Component)this.aboutIcon, gridBagConstraints);
        jLabel2.setFont(jLabel2.getFont().deriveFont(jLabel2.getFont().getStyle() | 1, jLabel2.getFont().getSize() + 2));
        jLabel2.setHorizontalAlignment(4);
        jLabel2.setText("jGameBase V0.71-4 (2023-11-24)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        jPanel6.add((Component)jLabel2, gridBagConstraints);
        jLabel3.setText("The Universal OS-Independent Retro-Gaming Frontend");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 3, 0);
        jPanel6.add((Component)jLabel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        jPanel6.add((Component)jLabel4, gridBagConstraints);
        jPanel1.add((Component)jPanel6, "North");
        jPanel7.setBorder(BorderFactory.createEtchedBorder());
        jPanel7.setLayout(new GridBagLayout());
        jLabel5.setText("GameBase:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.2;
        gridBagConstraints.insets = new Insets(5, 3, 3, 0);
        jPanel7.add((Component)jLabel5, gridBagConstraints);
        this.aboutName.setFont(this.aboutName.getFont().deriveFont(this.aboutName.getFont().getStyle() | 1));
        this.aboutName.setHorizontalAlignment(11);
        this.aboutName.setText("Commodore C64 - C64lite (my favourites) V16.0");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.2;
        gridBagConstraints.insets = new Insets(5, 0, 3, 3);
        jPanel7.add((Component)this.aboutName, gridBagConstraints);
        jLabel7.setText("Since:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.2;
        gridBagConstraints.insets = new Insets(0, 3, 3, 0);
        jPanel7.add((Component)jLabel7, gridBagConstraints);
        this.aboutSince.setFont(this.aboutSince.getFont().deriveFont(this.aboutSince.getFont().getStyle() | 1));
        this.aboutSince.setHorizontalAlignment(11);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.2;
        gridBagConstraints.insets = new Insets(0, 0, 3, 3);
        jPanel7.add((Component)this.aboutSince, gridBagConstraints);
        jLabel9.setText("Total games played:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.2;
        gridBagConstraints.insets = new Insets(0, 3, 3, 0);
        jPanel7.add((Component)jLabel9, gridBagConstraints);
        this.aboutGamesPlayed.setFont(this.aboutGamesPlayed.getFont().deriveFont(this.aboutGamesPlayed.getFont().getStyle() | 1));
        this.aboutGamesPlayed.setHorizontalAlignment(11);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.2;
        gridBagConstraints.insets = new Insets(0, 0, 3, 3);
        jPanel7.add((Component)this.aboutGamesPlayed, gridBagConstraints);
        jLabel11.setText("Total music played:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.2;
        gridBagConstraints.insets = new Insets(0, 3, 3, 0);
        jPanel7.add((Component)jLabel11, gridBagConstraints);
        this.aboutMusicPlayed.setFont(this.aboutMusicPlayed.getFont().deriveFont(this.aboutMusicPlayed.getFont().getStyle() | 1));
        this.aboutMusicPlayed.setHorizontalAlignment(11);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.2;
        gridBagConstraints.insets = new Insets(0, 0, 3, 3);
        jPanel7.add((Component)this.aboutMusicPlayed, gridBagConstraints);
        jLabel13.setText("Most played game:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.2;
        gridBagConstraints.insets = new Insets(0, 3, 5, 0);
        jPanel7.add((Component)jLabel13, gridBagConstraints);
        this.aboutGameMostPlayed.setFont(this.aboutGameMostPlayed.getFont().deriveFont(this.aboutGameMostPlayed.getFont().getStyle() | 1));
        this.aboutGameMostPlayed.setHorizontalAlignment(11);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.2;
        gridBagConstraints.insets = new Insets(0, 0, 5, 3);
        jPanel7.add((Component)this.aboutGameMostPlayed, gridBagConstraints);
        jPanel1.add((Component)jPanel7, "Center");
        jPanel8.setLayout(new GridBagLayout());
        gbCopyright.setText("GameBase Copyright \u00a9 1999 - 20xx James Burrows");
        gbCopyright.setText("GameBase Copyright \u00a9 1999 - 2023 James Burrows");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 3, 0);
        jPanel8.add((Component)gbCopyright, gridBagConstraints);
        jgbCopyright.setText("jGameBase Copyright \u00a9 2006 - 20xx Frank Gerbig");
        jgbCopyright.setText("jGameBase Copyright \u00a9 2006 - 2023 Frank Gerbig");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        jPanel8.add((Component)jgbCopyright, gridBagConstraints);
        jPanel1.add((Component)jPanel8, "South");
        jTabbedPane1.addTab("About", jPanel1);
        jPanel2.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        jPanel2.setLayout(new BoxLayout(jPanel2, 2));
        jScrollPane1.setHorizontalScrollBarPolicy(31);
        this.versionHistory.setEditable(false);
        this.versionHistory.setBackground(UIManager.getDefaults().getColor("TextField.inactiveBackground"));
        this.versionHistory.setLineWrap(true);
        this.versionHistory.setMargin(new Insets(5, 5, 5, 5));
        jScrollPane1.setViewportView(this.versionHistory);
        jPanel2.add(jScrollPane1);
        jTabbedPane1.addTab("Version History", jPanel2);
        jPanel3.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        jPanel3.setLayout(new GridBagLayout());
        this.gamebaseName.setFont(this.gamebaseName.getFont().deriveFont(this.gamebaseName.getFont().getStyle() | 1, this.gamebaseName.getFont().getSize() + 2));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 3, 0);
        jPanel3.add((Component)this.gamebaseName, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        jPanel3.add((Component)this.gamebaseIcon, gridBagConstraints);
        jScrollPane2.setHorizontalScrollBarPolicy(31);
        this.gamebaseAbout.setBackground(UIManager.getDefaults().getColor("TextField.inactiveBackground"));
        this.gamebaseAbout.setLineWrap(true);
        this.gamebaseAbout.setMargin(new Insets(5, 5, 5, 5));
        jScrollPane2.setViewportView(this.gamebaseAbout);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel3.add((Component)jScrollPane2, gridBagConstraints);
        jTabbedPane1.addTab("GameBase", jPanel3);
        jPanel4.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        jPanel4.setLayout(new BoxLayout(jPanel4, 2));
        jScrollPane3.setHorizontalScrollBarPolicy(31);
        jScrollPane3.setPreferredSize(new Dimension(80, 25));
        this.credits.setEditable(false);
        this.credits.setBackground(Color.black);
        this.credits.setFont(this.credits.getFont().deriveFont(this.credits.getFont().getStyle() | 1));
        this.credits.setForeground(Color.white);
        this.credits.setLineWrap(true);
        this.credits.setText("James Burrows  & Frank Gerbig present \n\n== jGameBase ==\nThe Universal Emulator Frontend and Database Utility\n\nConcept and design by James Burrows\nJava version by Frank Gerbig\nArtwork by Jacek Bogucki\n\nBeta Testers: \nThe GB64 Team, Jacek Bogucki, Allan Hartigan and Shane Holding.\n\n\nGreets go out to: \nThe GB64 Team, The HVSC Team, Peter Sanden, Per Bolmstedt, Kwed, Red Snapper, Adam Lorentzon, Matthew Allen, Mahoney, and everyone else who has supported GameBase and jGameBase!\n\n\nNo Speccy users were harmed during the making of this program.\n\n\n");
        this.credits.setWrapStyleWord(true);
        this.credits.setMargin(new Insets(5, 5, 5, 5));
        this.credits.setText(String.valueOf(this.credits.getText()) + "GameBase Copyright \u00a9 1999-" + "2023" + " James Burrows\n");
        this.credits.setText(String.valueOf(this.credits.getText()) + "jGameBase Copyright \u00a9 2006-" + "2023" + " Frank Gerbig\n");
        this.credits.setText(String.valueOf(this.credits.getText()) + "All rights reserved.\n");
        jScrollPane3.setViewportView(this.credits);
        jPanel4.add(jScrollPane3);
        jTabbedPane1.addTab("Credits", jPanel4);
        jPanel5.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        jPanel5.setLayout(new BoxLayout(jPanel5, 2));
        this.license.setEditable(false);
        this.license.setBackground(UIManager.getDefaults().getColor("TextField.inactiveBackground"));
        this.license.setLineWrap(true);
        this.license.setText("jGameBase is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation; either version 3 of the License, or (at your option) any later version. jGameBase is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the files \"License.txt\" and \"gpl-3.0.txt\" in the jGameBase directory for more details.\n");
        this.license.setWrapStyleWord(true);
        this.license.setAutoscrolls(false);
        this.license.setMargin(new Insets(5, 5, 5, 5));
        jPanel5.add(this.license);
        jTabbedPane1.addTab("License", jPanel5);
        this.getContentPane().add((Component)jTabbedPane1, "Center");
        this.pack();
        this.setLocationRelativeTo(null);
    }

    private void formWindowClosing(WindowEvent evt) {
        this.dispose();
    }
}

